*Command File For "Domestic Judicial Instituitons and Human Rights Treaty Violation"

*Contains examples of commands used to produce results in Tables 2-5

*************************************************************************************
*Table 2 model example (using Contract Intensive Money measure)                     *
*************************************************************************************
biprobit(ratinfull=cim priothreat cap regrev pop ingo rifglobal rifregavg ratyears _ratspline1 _ratspline2 _ratspline3 ratinfullfailures)(anytorture=cim priothreat cap regrev pop ingo atglobal atregavg atyears _atspline1 _atspline2 _atspline3 anytfailures), cluster(ccode)

*************************************************************************************
*Table 3 model example (using Contract Intensive Money)                             *
*************************************************************************************
biprobit(ratinfull=cim priothreat cap regrev pop ingo rifglobal rifregavg ratyears _ratspline1 _ratspline2 _ratspline3 ratinfullfailures)(badtorture=cim priothreat cap regrev pop ingo badglobal btregavg btyears _btspline1 _btspline2 _btspline3 badtfailures), cluster(ccode)

*************************************************************************************
*Table 4-5 example (Code for Systematic Torture simulations)                        *
*************************************************************************************
*Draw 10000 simulated parameters
drawnorm JS_b1-JS_b29, n(10000) means(e(b)) cov(e(V)) 

*Rename variables
rename JS_b1 ji_r
rename JS_b2 threat_r
rename JS_b3 cap_r
rename JS_b4 regrev_r
rename JS_b5 pop_r
rename JS_b6 ingo_r
rename JS_b7 rifglobal_r
rename JS_b8 rifsubavg_r
rename JS_b9 ratyears_r
rename JS_b10 rspline1_r
rename JS_b11 rspline2_r
rename JS_b12 rspline3_r
rename JS_b13 ratfails_r
rename JS_b14 constant_r
rename JS_b15 ji_t
rename JS_b16 threat_t
rename JS_b17 cap_t
rename JS_b18 regrev_t
rename JS_b19 pop_t
rename JS_b20 ingo_t
rename JS_b21 badglobal_t
rename JS_b22 badsubavg_t
rename JS_b23 btyears_t
rename JS_b24 btspline1_t
rename JS_b25 btspline2_t
rename JS_b26 btspline3_t
rename JS_b27 badfails_t
rename JS_b28 constant_t
rename JS_b29 rho_r

*Fix values for X
gen priothreat=.252394 
gen cap=.007197
gen regrev=.5253
gen pop=42937.1
gen ingo=874.25
gen rifglobal=.295604
gen rifsubavg=.337362
gen ratyears=3.73187
gen ratspline1=-274.311
gen ratspline2=-136.532
gen ratspline3=-127.554
gen ratinfullfail=1.75718
gen badglobal=.617083
gen btsubavg=.688532
gen btyears=2.17
gen btspline1=-114.3014
gen btspline2=-29.16
gen btspline3=-66.37
gen badfails=2.40


*Generate Xbeta for high and law values of CIM measure

gen y1low= ji_r*.5+ threat_r* priothreat+ cap_r* cap+ regrev_r* regrev+ pop_r* pop+ ingo_r* ingo+ rifglobal_r* rifglobal+ rifsubavg_r* rifsubavg+ ratyears_r* ratyears+ rspline1_r* ratspline1+ rspline2_r* ratspline2+ rspline3_r* ratspline3+ ratfails_r* ratinfullfail+ constant_r
gen y2low= ji_t*.5+ threat_t* priothreat+ cap_t* cap+ regrev_t* regrev+ pop_t* pop+ ingo_t* ingo+ badglobal_t* badglobal+ badsubavg_t* btsubavg+ btyears_t* btyears+ btspline1_t* btspline1+ btspline2_t* btspline2+ btspline3_t* btspline3+ badfails_t* badfails+ constant_t
gen y1high= ji_r*.99+ threat_r* priothreat+ cap_r* cap+ regrev_r* regrev+ pop_r* pop+ ingo_r* ingo+ rifglobal_r* rifglobal+ rifsubavg_r* rifsubavg+ ratyears_r* ratyears+ rspline1_r* ratspline1+ rspline2_r* ratspline2+ rspline3_r* ratspline3+ ratfails_r* ratinfullfail+ constant_r
gen y2high= ji_t*.99+ threat_t* priothreat+ cap_t* cap+ regrev_t* regrev+ pop_t* pop+ ingo_t* ingo+ badglobal_t* badglobal+ badsubavg_t* btsubavg+ btyears_t* btyears+ btspline1_t* btspline1+ btspline2_t* btspline2+ btspline3_t* btspline3+ badfails_t* badfails+ constant_t

*Creat joint probabilities and confidence intervals [Pr(Ratify=1 & Torture=1); Rho suppressed given insignificant estimates*
gen p11low=norm(y1low)*norm(y2low)
gen p11high=norm(y1high)*norm(y2high)
gen p11diff_hl=p11high-p11low

_pctile p11diff_hl, p(.00001,95)
gen diff11low_cim=r(r1)
gen diff11high_cim=r(r2)

*Creat joint probabilities and confidence intervals [Pr(Ratify=0 & Torture=1); Rho suppressed given insignificant estimates*
gen p01low=(1-norm(y1low))*norm(y2low)
gen p01high=(1-norm(y1high))*norm(y2high)
gen p01diff_hl=p01high-p01low

_pctile p01diff_hl, p(5,99.99)
gen diff01low_cim=r(r1)
gen diff01high_cim=r(r2)

