program define randomcases

* This program selected data subsamples for the ISQ article
* "Market Rules" by Bartilow and Voss.  Although provided for
* replication purposes, Voss makes the code available here for
* public, non-commercial use should anyone wish to adapt it 
* into a more generic form.  Voss assumes no responsibility
* for the performance of the procedure in another's hands,
* but naturally would appreciate receiving appropriate credit
* should anyone decide to use this file for their research needs.

	version 7.0
	tempvar cntynums

quietly {
	insheet using "Nations.csv", comma

	local counter = 1
	while `counter' < 7 {
		local plant = 680813*`counter'
		g `cntynums' = nationid
		set seed `plant'

		log using "cases`counter'.do", text replace
		log off

		local indexer = 72

		while `indexer'>50 {
			local dropcase=int(72*uniform())+1
			local dropid=`cntynums'[`dropcase']
			if `dropid' != 0 {	
				local dropname = nation[`dropcase']
				log on
				noisily di `"drop if (exporter==""' "`dropname'" `"" | importer==""' "`dropname'" `"")"'
				log off
				replace `cntynums' = 0 in `dropcase'
				local indexer = `indexer'-1
				}
	
			}

		log close
		noisily di " "
		drop `cntynums'
		local counter = `counter'+1
		}
}

clear
end
