clear
version 7.0
set mem 148m

*NOTE: This batch file presumes that STATA has been set to access the subdirectory where the data appear and where the
*results should go.  However, file names always appear in quote marks, so a user could add the path to commands.
*For example, in our usage, the second command said:   use "c:\data\tradefinal(v7).dta", clear

*Set dependent variable here
local sector "genexp"

use "tradefinal(v7).dta", clear

* Temporary fix for impossible language percentage
replace langpct2=ln(1) if (dyad==2468 | dyad==3869)
rename Border2 border2

*Reduce data size to conserve memory
#delimit ;
keep gdpi2 gdpj2 popi2 popj2 dist2 border2 langpct2 relgpct2 mid2 allyd2 alltau2 allys2 demd2 demi2 demj2 exporter importer year `sector';
#delimit cr
compress

#delimit ;
order exporter importer year `sector' gdpi2 gdpj2 popi2 popj2 dist2 border2 langpct2 relgpct2 mid2 allyd2 alltau2 allys2 demd2 demi2 demj2;
#delimit cr

preserve
do "cases1.do"
save "cases1.dta", replace
summ `sector'
restore

preserve
do "cases2.do"
save "cases2.dta", replace
summ `sector'
restore

preserve
do "cases3.do"
save "cases3.dta", replace
summ `sector'
restore

preserve
do "cases4.do"
save "cases4.dta", replace
summ `sector'
restore

preserve
do "cases5.do"
save "cases5.dta", replace
summ `sector'
restore

preserve
do "cases6.do"
save "cases6.dta", replace
summ `sector'
restore
